﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace VIRP_WEB.Controls.Custom.BPR
{
    public partial class controls_BaseControlTextBox : System.Web.UI.UserControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }
        public string Text
        {
            get
            {
                return TextBoxControl.Text;
            }
            set
            {
                TextBoxControl.Text = value;
            }
        }

        public string LabelText
        {
            get
            {
                return LabelForTextBoxControl.Text;
            }
            set
            {
                LabelForTextBoxControl.Text = value;
            }
        }

        public bool IsMultiline
        {
            set
            {
                if (value)
                {
                    TextBoxControl.TextMode = TextBoxMode.MultiLine;
                    TextBoxControl.Rows = 3;
                }
            }
        }

        public string Tooltip
        {
            set
            {
                LabelForTextBoxControl.ToolTip = value;
                TextBoxControl.ToolTip = value;
            }
        }

        public bool IncludeLabel
        {
            set
            {
                LabelForTextBoxControl.Visible = value;
            }
        }

        public System.Nullable<int> MaxLength
        {
            set
            {
                if (value != null)
                {
                    TextBoxControl.MaxLength = (int)value;
                }
            }
        }

        public System.Nullable<int> DateElementWidth
        {
            set
            {
                if (value != null)
                {
                    TextBoxControl.Width = new Unit((int)value);
                }
            }
        }

        /// <summary>
        /// Set Required validator
        /// </summary>
        public bool IsRequired
        {
            set
            {
                if (value)
                {
                    RequiredFieldValidatorControl.Visible = true;
                    RequiredFieldValidatorControl.Enabled = true;
                }
                else
                {
                    RequiredFieldValidatorControl.Visible = false;
                    RequiredFieldValidatorControl.Enabled = false;
                }
            }
        }

        /// <summary>
        /// Set the validationErrorMessage
        /// </summary>
        public string ValidationErrorMessage
        {
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    if (value.Contains("is required"))
                    {
                        RequiredFieldValidatorControl.ErrorMessage = value;
                        RegularExpressionValidatorTextBoxControl.Visible = false;
                        RegularExpressionValidatorTextBoxControl.Enabled = false;
                    }
                    else
                    {
                        RegularExpressionValidatorTextBoxControl.ErrorMessage = value;
                        RegularExpressionValidatorTextBoxControl.Visible = true;
                        RegularExpressionValidatorTextBoxControl.Enabled = true;
                    }

                }
            }
        }

        /// <summary>
        /// Set validation expression
        /// </summary>
        public string ValidationExpression
        {
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    RegularExpressionValidatorTextBoxControl.ValidationExpression = value;
                    RegularExpressionValidatorTextBoxControl.Visible = true;
                    RegularExpressionValidatorTextBoxControl.Enabled = true;
                }
            }
        }

        /// <summary>
        /// Set validation group
        /// </summary>
        public string ValidationGroup
        {
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    RegularExpressionValidatorTextBoxControl.ValidationGroup = value;
                    RegularExpressionValidatorTextBoxControl.Visible = true;
                    RegularExpressionValidatorTextBoxControl.Enabled = true;
                    RequiredFieldValidatorControl.ValidationGroup = value;
                }
            }
        }

        public void LoadControlsFromObject(string text, string labelText, string tooltip, bool includeLabel, System.Nullable<int> maxLength, System.Nullable<int> dataElementWidth, string validationGroup, string validationErrorMsg, string validationExpression, bool isRequired)
        {
            if (!string.IsNullOrEmpty(tooltip))
            {
                Tooltip = tooltip;
            }
            if (!string.IsNullOrEmpty(text))
            {
                Text = text;
            }
            if (!string.IsNullOrEmpty(labelText))
            {
                LabelText = labelText;
            }

            IncludeLabel = includeLabel;
            MaxLength = maxLength;
            DateElementWidth = dataElementWidth;
            ValidationGroup = validationGroup;
            ValidationErrorMessage = validationErrorMsg;
            ValidationExpression = validationExpression;
            IsRequired = isRequired;
        }
    }
}